//
//  GyroDemoViewController.m
//  GyroDemo
//
//  Created by Jonathan Diehl on 31.05.11.
//  Copyright 2011 RWTH. All rights reserved.
//

// the update frequency
#define kUpdateFrequency 30.0

// alpha value for the low-pass filter
#define kAlpha 0.08

#import "GyroDemoViewController.h"

@implementation GyroDemoViewController

@synthesize barX, barY, barZ;


// this methos is called frequently by the timer
- (void)update:(NSTimer *)theTimer;
{
	CMRotationRate rotation = manager.gyroData.rotationRate;
	
	// filter the rotation (ignoring invalid readings)
	if(rotation.x*rotation.x < 100.0) filterRotation.x = kAlpha * rotation.x + (1.0-kAlpha) * filterRotation.x;
	if(rotation.y*rotation.y < 100.0) filterRotation.y = kAlpha * rotation.y + (1.0-kAlpha) * filterRotation.y;
	if(rotation.z*rotation.z < 100.0) filterRotation.z = kAlpha * rotation.z + (1.0-kAlpha) * filterRotation.z;	
	
	// update the UI
	barX.progress = 0.5 + filterRotation.x/2.0;
	barY.progress = 0.5 + filterRotation.y/2.0;
	barZ.progress = 0.5 + filterRotation.z/2.0;
}


#pragma mark UIViewController

// init view
- (void)viewDidLoad
{
    [super viewDidLoad];
	
	// init the core motion manager
	manager = [[CMMotionManager alloc] init];
	manager.gyroUpdateInterval = 1.0/kUpdateFrequency;
}

// did appear
- (void)viewDidAppear:(BOOL)animated;
{
	// start reading gyro data
	[manager startGyroUpdates];
	
	// start timer
	timer = [[NSTimer scheduledTimerWithTimeInterval:1.0/kUpdateFrequency target:self selector:@selector(update:) userInfo:nil repeats:YES] retain];
}

// will disappear
- (void)viewWillDisappear:(BOOL)animated;
{
	// stop gyro updates
	[manager stopGyroUpdates];
	
	// stop the timer
	[timer invalidate];
	[timer release];
}

// clean up
- (void)dealloc
{
	[timer invalidate];
	[timer release];
	
	[manager release];
    [super dealloc];
}

@end
